--------------------------------------------------------------------
--            SymCACP Script Module Run Length
-- Symmetrical CA Control Panel   symCACPscript-1
--file for strip Run Length
--------------------------------------------------------------------
--  P. Rendell  27/07/2020
--------------------------------------------------------------------
-- input script data
-- scriptFileData.GEO
-- scriptFileData.RULES
-- scriptFileData.SEEDS
-- scriptFileData.WIDTH
-- scriptFileData.HIGHT
-- scriptFileData.STEP1
-- scriptFileData.RUNLENG
-- scriptFileData.CELL_X
-- scriptFileData.CELL_Y
-- scriptFileData.RESULTS_NEW
-- scriptFileData.RESULTS_OLD
-- scriptFileData.LOGFILE
-- scriptFileData.SQUARE

--
-- output 
-- RULE, WD, HT, SEED, GEO, GEN, RUNLEN


------------------------------------------------------------

local scriptType = "script2-runLength"
local m={}			-- class table
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
--  "r" = rule, "s" = seed, "d" = decimal "t" = text, "g" = geo
-- "R" = required
m.colonList = {['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}}
m.equalList = {['WIDTH'] = {"d","R"}, ['HIGHT'] = {"d",""},
                   ['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"},
                   ['STEP1'] = {"d","R"}, ['RUNLENG'] = {"d","R"},
                   ['GEO'] = {'g',""}, ['CELL_X'] = {'d',"R"}, ['CELL_Y'] = {'d',"R"} }

------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==============================================================================
------------------------------------------------------------
-- If a run is interruppted then the last seed run can be ignored as it will be incomplete.
-- 
local function openOutFile()
   local s = {}
   local lastSeedRun = {}
   local lastSeedRunKey = ''
   local outData = {}
   local inFile, outFile, line, words, key, keyFound, noLines
   local outFileOpen = false
   s.linesDone = {}
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile and scriptFileData.RESULTS_OLD then         
         outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if outFile then
            line = inFile:read("*l")
            while line do
               if not line:upper():find("RULE") then
                  outFile:write(line..'\n')
               end
               line = inFile:read("*l")
            end
            inFile:close()
            outFile:close()
            s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            s.outFile:write("RULE,GEO,WIDTH,HIGHT,SEED,GEN,RUNLEN\n")
            outFileOpen = true
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if s.outFile and inFile then
               line = inFile:read("*l")
               keyFound = false
               while line do
                  if not line:upper():find("RULE") then
                     words = split(line)
                     if (#words == 7) then		-- 1 RULE, 2 GEO, 3 WV, 4 HV, 5 SEED, 6 GEN, 7 RUNLEN
                        key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]
                        if (key ~= lastSeedRunKey) then
                           for i = 1, #lastSeedRun do
                              s.outFile:write(lastSeedRun[i]..'\n')
                           end
                           s.linesDone[lastSeedRunKey] = true
                           lastSeedRun = {}
                           lastSeedRunKey = key
                        end
                        lastSeedRun[#lastSeedRun+1] = line
                     else
                        logFile:write('openOutFile line '..line..' not 7 words\n')
                     end
                  end
                  line = inFile:read("*l")
               end
            else
               logFile:write("openOutFile (2nd) files not open infile:"..m.util.bool2txt(inFile).." outfile:"..m.util.bool2txt(m.outFile).."\n")
               s.outFile:close()
               outFileOpen = false
            end
         else
            comProcs.showTextOV('Failed to input output file '..scriptFileData.RESULTS_NEW)
            logFile:write('Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
         end
      end
      if inFile then
         inFile:close()
      end
      if not outFileOpen then
         s.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
         s.outFile:write("RULE,GEO,WIDTH,HIGHT,SEED,GEN,RUNLEN\n")
      end
      if not s.outFile then
         comProcs.showTextOV('Failed to open output file '..scriptFileData.RESULTS_NEW)
         logFile:write('Failed to open input file '.."scriptFileData.RESULTS_NEW\n")
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end
   return(s)
end
------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)

   ---------------------  script data-----------------------
   --  WIDTH =,HIGHT =,RUNLENG =, DO=RUNLENGTH
   --  SEEDS:, STEP1 =,RULES:, CELL_X=, CELL_Y=, 
   ---------------------------------------------------------
   g.show('Runlength Analysis Started')
   logFile:write('\nRunlength Analysis Started\n')
   
   local rule, seed, state, newState, gen, outData, outFile, inFile
   local started = false
   local s, wv, hv
   local startTime = os.clock()
   g.show("Script Run Length")
   
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      s = openOutFile()
      local geoList = {'D','O'}
      if scriptFileData.GEO ~= 'B' then
         geoList = {scriptFileData.GEO}
      end
      wv = scriptFileData.WIDTH
      hv = scriptFileData.HIGHT
      
      logFile:write('Runlength get files\n')
      if s.outFile then
         logFile:write('Runlength files OK\n')
         for i1,rule in pairs(scriptFileData.RULES) do
            g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..rule..' ')
            for i2,seed in pairs(scriptFileData.SEEDS) do
               g.show("seed "..seed)
               for i3,geo in pairs(geoList) do
                  key = rule..':'..geo..':'..wv..':'..hv..':'..seed
                  if (not s.linesDone[key]) then
                     gr.doBuild(' SymCACP RunLen ', wv, hv, seed, geo, rule)  -- w, h, seed, rule, format
                     g.run(scriptFileData.STEP1)
                     g.update()
                     state = g.getcell(scriptFileData.CELL_X, scriptFileData.CELL_Y)
                     runLen = 0
                     started = false
                     for iVal = 1, scriptFileData.RUNLENG do
                        g.run(1)
                        newState = g.getcell(scriptFileData.CELL_X, scriptFileData.CELL_Y)
                        if (newState == state) then
                           runLen = runLen + 1
                        else
                           if (started) then
                              s.outFile:write(string.format("%s,%s,%s,%s,%s,%s,%s\n", rule, geo, wv, hv, seed, g.getgen(), runLen))
                           end
                           runLen = 0
                           started = true
                           state = newState
                        end
                     end
                  end
               end
            end
         end
         s.outFile:close()
      end
      local elapsed = os.clock()-startTime
      local elHrs = math.floor(elapsed/3600)
      local elMins = math.floor((elapsed-elHrs*3600)/60)
      local elSecs = (elapsed-elHrs*3600-elMins*60)   
      logFile:write(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      g.show(string.format("Finished Run Length in %2d Hrs %2d Mins %2.2f Secs\n", elHrs,elMins,elSecs  ))
      if logDiverted then
         logFile:flush()
         reDivertLog()
      end
   else
      comProcs.showTextOV('No Script file Loaded')
   end
end
--==============================================================================
------------------------------------------------------------------------------------------------


return m
------------------------------------------------------------
